package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLicenseManagerReportGeneratorResponse(
    reportGenerator: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse = {
    import GetLicenseManagerReportGeneratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse
      .builder()
      .optionallyWith(reportGenerator.map(value => value.buildAwsValue()))(
        _.reportGenerator
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse
      .wrap(buildAwsValue())
}
object GetLicenseManagerReportGeneratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseManagerReportGeneratorResponse(
          reportGeneratorValue.map(value => value.editable)
        )
    def reportGeneratorValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
    ]
    def reportGenerator: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
    ] = AwsError.unwrapOptionField("reportGenerator", reportGeneratorValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly {
    override def reportGeneratorValue: Option[
      io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.ReadOnly
    ] = scala
      .Option(impl.reportGenerator())
      .map(value =>
        io.github.vigoo.zioaws.licensemanager.model.ReportGenerator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorResponse.ReadOnly =
    new Wrapper(impl)
}
