package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLicenseManagerReportGeneratorRequest(
    licenseManagerReportGeneratorArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest = {
    import GetLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest
      .builder()
      .licenseManagerReportGeneratorArn(
        licenseManagerReportGeneratorArn: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorRequest
      .wrap(buildAwsValue())
}
object GetLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .GetLicenseManagerReportGeneratorRequest(
          licenseManagerReportGeneratorArnValue
        )
    def licenseManagerReportGeneratorArnValue: String
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(licenseManagerReportGeneratorArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorRequest.ReadOnly {
    override def licenseManagerReportGeneratorArnValue: String =
      impl.licenseManagerReportGeneratorArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest
  ): io.github.vigoo.zioaws.licensemanager.model.GetLicenseManagerReportGeneratorRequest.ReadOnly =
    new Wrapper(impl)
}
