package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.Arn
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGrantRequest(
    grantArn: Arn,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.GetGrantRequest = {
    import GetGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetGrantRequest
      .builder()
      .grantArn(grantArn: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.GetGrantRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.GetGrantRequest
      .wrap(buildAwsValue())
}
object GetGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.GetGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.GetGrantRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .GetGrantRequest(grantArnValue, versionValue.map(value => value))
    def grantArnValue: Arn
    def versionValue: Option[String]
    def grantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(grantArnValue)
    def version: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.GetGrantRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.GetGrantRequest.ReadOnly {
    override def grantArnValue: Arn = impl.grantArn(): Arn
    override def versionValue: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.GetGrantRequest
  ): io.github.vigoo.zioaws.licensemanager.model.GetGrantRequest.ReadOnly =
    new Wrapper(impl)
}
