package io.github.vigoo.zioaws.licensemanager.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EntitlementUsage(
    name: String,
    consumedValue: String,
    maxCount: Option[String] = None,
    unit: io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.EntitlementUsage = {
    import EntitlementUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.EntitlementUsage
      .builder()
      .name(name: java.lang.String)
      .consumedValue(consumedValue: java.lang.String)
      .optionallyWith(maxCount.map(value => value: java.lang.String))(
        _.maxCount
      )
      .unit(unit.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage
      .wrap(buildAwsValue())
}
object EntitlementUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.EntitlementUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage =
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage(
        nameValue,
        consumedValueValue,
        maxCountValue.map(value => value),
        unitValue
      )
    def nameValue: String
    def consumedValueValue: String
    def maxCountValue: Option[String]
    def unitValue
        : io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def consumedValue: ZIO[Any, Nothing, String] =
      ZIO.succeed(consumedValueValue)
    def maxCount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxCount", maxCountValue)
    def unit: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
    ] = ZIO.succeed(unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.EntitlementUsage
  ) extends io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def consumedValueValue: String = impl.consumedValue(): String
    override def maxCountValue: Option[String] =
      scala.Option(impl.maxCount()).map(value => value: String)
    override def unitValue
        : io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit =
      io.github.vigoo.zioaws.licensemanager.model.EntitlementDataUnit
        .wrap(impl.unit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.EntitlementUsage
  ): io.github.vigoo.zioaws.licensemanager.model.EntitlementUsage.ReadOnly =
    new Wrapper(impl)
}
