package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.BoxBoolean
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Entitlement(
    name: String,
    value: Option[String] = None,
    maxCount: Option[Long] = None,
    overage: Option[BoxBoolean] = None,
    unit: io.github.vigoo.zioaws.licensemanager.model.EntitlementUnit,
    allowCheckIn: Option[BoxBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.Entitlement = {
    import Entitlement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Entitlement
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(maxCount.map(value => value: java.lang.Long))(_.maxCount)
      .optionallyWith(overage.map(value => value: java.lang.Boolean))(_.overage)
      .unit(unit.unwrap)
      .optionallyWith(allowCheckIn.map(value => value: java.lang.Boolean))(
        _.allowCheckIn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.Entitlement
      .wrap(buildAwsValue())
}
object Entitlement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.Entitlement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.licensemanager.model.Entitlement =
      io.github.vigoo.zioaws.licensemanager.model.Entitlement(
        nameValue,
        valueValue.map(value => value),
        maxCountValue.map(value => value),
        overageValue.map(value => value),
        unitValue,
        allowCheckInValue.map(value => value)
      )
    def nameValue: String
    def valueValue: Option[String]
    def maxCountValue: Option[Long]
    def overageValue: Option[BoxBoolean]
    def unitValue: io.github.vigoo.zioaws.licensemanager.model.EntitlementUnit
    def allowCheckInValue: Option[BoxBoolean]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def value: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", valueValue)
    def maxCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxCount", maxCountValue)
    def overage: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField("overage", overageValue)
    def unit: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUnit
    ] = ZIO.succeed(unitValue)
    def allowCheckIn: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField("allowCheckIn", allowCheckInValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.Entitlement
  ) extends io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def valueValue: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override def maxCountValue: Option[Long] =
      scala.Option(impl.maxCount()).map(value => value: Long)
    override def overageValue: Option[BoxBoolean] =
      scala.Option(impl.overage()).map(value => value: BoxBoolean)
    override def unitValue
        : io.github.vigoo.zioaws.licensemanager.model.EntitlementUnit =
      io.github.vigoo.zioaws.licensemanager.model.EntitlementUnit
        .wrap(impl.unit())
    override def allowCheckInValue: Option[BoxBoolean] =
      scala.Option(impl.allowCheckIn()).map(value => value: BoxBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.Entitlement
  ): io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly =
    new Wrapper(impl)
}
