package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{ClientToken, Arn}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseVersionRequest(
    licenseArn: Arn,
    licenseName: String,
    productName: String,
    issuer: io.github.vigoo.zioaws.licensemanager.model.Issuer,
    homeRegion: String,
    validity: io.github.vigoo.zioaws.licensemanager.model.DatetimeRange,
    licenseMetadata: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.Metadata]
    ] = None,
    entitlements: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement
    ],
    consumptionConfiguration: io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration,
    status: io.github.vigoo.zioaws.licensemanager.model.LicenseStatus,
    clientToken: ClientToken,
    sourceVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest = {
    import CreateLicenseVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest
      .builder()
      .licenseArn(licenseArn: java.lang.String)
      .licenseName(licenseName: java.lang.String)
      .productName(productName: java.lang.String)
      .issuer(issuer.buildAwsValue())
      .homeRegion(homeRegion: java.lang.String)
      .validity(validity.buildAwsValue())
      .optionallyWith(
        licenseMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseMetadata)
      .entitlements(entitlements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .consumptionConfiguration(consumptionConfiguration.buildAwsValue())
      .status(status.unwrap)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest
      .wrap(buildAwsValue())
}
object CreateLicenseVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest =
      io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest(
        licenseArnValue,
        licenseNameValue,
        productNameValue,
        issuerValue.editable,
        homeRegionValue,
        validityValue.editable,
        licenseMetadataValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        entitlementsValue.map { item =>
          item.editable
        },
        consumptionConfigurationValue.editable,
        statusValue,
        clientTokenValue,
        sourceVersionValue.map(value => value)
      )
    def licenseArnValue: Arn
    def licenseNameValue: String
    def productNameValue: String
    def issuerValue: io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly
    def homeRegionValue: String
    def validityValue
        : io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ]
    def entitlementsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly]
    def consumptionConfigurationValue
        : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    def statusValue: io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
    def clientTokenValue: ClientToken
    def sourceVersionValue: Option[String]
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def licenseName: ZIO[Any, Nothing, String] = ZIO.succeed(licenseNameValue)
    def productName: ZIO[Any, Nothing, String] = ZIO.succeed(productNameValue)
    def issuer: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly
    ] = ZIO.succeed(issuerValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def validity: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly
    ] = ZIO.succeed(validityValue)
    def licenseMetadata: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly
    ]] = AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def entitlements: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly
    ]] = ZIO.succeed(entitlementsValue)
    def consumptionConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly
    ] = ZIO.succeed(consumptionConfigurationValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
    ] = ZIO.succeed(statusValue)
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
    def sourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest.ReadOnly {
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def licenseNameValue: String = impl.licenseName(): String
    override def productNameValue: String = impl.productName(): String
    override def issuerValue
        : io.github.vigoo.zioaws.licensemanager.model.Issuer.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.Issuer.wrap(impl.issuer())
    override def homeRegionValue: String = impl.homeRegion(): String
    override def validityValue
        : io.github.vigoo.zioaws.licensemanager.model.DatetimeRange.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.DatetimeRange
        .wrap(impl.validity())
    override def licenseMetadataValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Metadata.ReadOnly]
    ] = scala
      .Option(impl.licenseMetadata())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Metadata.wrap(item)
        }.toList
      )
    override def entitlementsValue: List[
      io.github.vigoo.zioaws.licensemanager.model.Entitlement.ReadOnly
    ] = impl
      .entitlements()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.licensemanager.model.Entitlement.wrap(item)
      }
      .toList
    override def consumptionConfigurationValue
        : io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration.ReadOnly =
      io.github.vigoo.zioaws.licensemanager.model.ConsumptionConfiguration
        .wrap(impl.consumptionConfiguration())
    override def statusValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseStatus =
      io.github.vigoo.zioaws.licensemanager.model.LicenseStatus
        .wrap(impl.status())
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
    override def sourceVersionValue: Option[String] =
      scala.Option(impl.sourceVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseVersionRequest.ReadOnly =
    new Wrapper(impl)
}
