package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  BoxBoolean,
  BoxLong
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLicenseConfigurationRequest(
    name: String,
    description: Option[String] = None,
    licenseCountingType: io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType,
    licenseCount: Option[BoxLong] = None,
    licenseCountHardLimit: Option[BoxBoolean] = None,
    licenseRules: Option[Iterable[String]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.licensemanager.model.Tag]] =
      None,
    disassociateWhenNotFound: Option[BoxBoolean] = None,
    productInformationList: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.ProductInformation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest = {
    import CreateLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .licenseCountingType(licenseCountingType.unwrap)
      .optionallyWith(licenseCount.map(value => value: java.lang.Long))(
        _.licenseCount
      )
      .optionallyWith(
        licenseCountHardLimit.map(value => value: java.lang.Boolean)
      )(_.licenseCountHardLimit)
      .optionallyWith(
        licenseRules.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.licenseRules)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        disassociateWhenNotFound.map(value => value: java.lang.Boolean)
      )(_.disassociateWhenNotFound)
      .optionallyWith(
        productInformationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productInformationList)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationRequest =
      io.github.vigoo.zioaws.licensemanager.model
        .CreateLicenseConfigurationRequest(
          nameValue,
          descriptionValue.map(value => value),
          licenseCountingTypeValue,
          licenseCountValue.map(value => value),
          licenseCountHardLimitValue.map(value => value),
          licenseRulesValue.map(value => value),
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          disassociateWhenNotFoundValue.map(value => value),
          productInformationListValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def nameValue: String
    def descriptionValue: Option[String]
    def licenseCountingTypeValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    def licenseCountValue: Option[BoxLong]
    def licenseCountHardLimitValue: Option[BoxBoolean]
    def licenseRulesValue: Option[List[String]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]]
    def disassociateWhenNotFoundValue: Option[BoxBoolean]
    def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def licenseCountingType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
    ] = ZIO.succeed(licenseCountingTypeValue)
    def licenseCount: ZIO[Any, AwsError, BoxLong] =
      AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, AwsError, BoxBoolean] = AwsError
      .unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def licenseRules: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def disassociateWhenNotFound: ZIO[Any, AwsError, BoxBoolean] =
      AwsError.unwrapOptionField(
        "disassociateWhenNotFound",
        disassociateWhenNotFoundValue
      )
    def productInformationList: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "productInformationList",
      productInformationListValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationRequest.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def licenseCountingTypeValue
        : io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType =
      io.github.vigoo.zioaws.licensemanager.model.LicenseCountingType
        .wrap(impl.licenseCountingType())
    override def licenseCountValue: Option[BoxLong] =
      scala.Option(impl.licenseCount()).map(value => value: BoxLong)
    override def licenseCountHardLimitValue: Option[BoxBoolean] =
      scala.Option(impl.licenseCountHardLimit()).map(value => value: BoxBoolean)
    override def licenseRulesValue: Option[List[String]] = scala
      .Option(impl.licenseRules())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.Tag.wrap(item)
        }.toList
      )
    override def disassociateWhenNotFoundValue: Option[BoxBoolean] = scala
      .Option(impl.disassociateWhenNotFound())
      .map(value => value: BoxBoolean)
    override def productInformationListValue: Option[List[
      io.github.vigoo.zioaws.licensemanager.model.ProductInformation.ReadOnly
    ]] = scala
      .Option(impl.productInformationList())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.ProductInformation
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
