package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{
  StatusReasonMessage,
  Arn,
  ClientToken
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateGrantVersionRequest(
    clientToken: ClientToken,
    grantArn: Arn,
    grantName: Option[String] = None,
    allowedOperations: Option[
      Iterable[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ] = None,
    status: Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      None,
    statusReason: Option[StatusReasonMessage] = None,
    sourceVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest = {
    import CreateGrantVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest
      .builder()
      .clientToken(clientToken: java.lang.String)
      .grantArn(grantArn: java.lang.String)
      .optionallyWith(grantName.map(value => value: java.lang.String))(
        _.grantName
      )
      .optionallyWith(
        allowedOperations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedOperationsWithStrings)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest
      .wrap(buildAwsValue())
}
object CreateGrantVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest =
      io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest(
        clientTokenValue,
        grantArnValue,
        grantNameValue.map(value => value),
        allowedOperationsValue.map(value => value),
        statusValue.map(value => value),
        statusReasonValue.map(value => value),
        sourceVersionValue.map(value => value)
      )
    def clientTokenValue: ClientToken
    def grantArnValue: Arn
    def grantNameValue: Option[String]
    def allowedOperationsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ]
    def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus]
    def statusReasonValue: Option[StatusReasonMessage]
    def sourceVersionValue: Option[String]
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
    def grantArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(grantArnValue)
    def grantName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("grantName", grantNameValue)
    def allowedOperations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]] = AwsError.unwrapOptionField("allowedOperations", allowedOperationsValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.licensemanager.model.GrantStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def statusReason: ZIO[Any, AwsError, StatusReasonMessage] =
      AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def sourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest.ReadOnly {
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
    override def grantArnValue: Arn = impl.grantArn(): Arn
    override def grantNameValue: Option[String] =
      scala.Option(impl.grantName()).map(value => value: String)
    override def allowedOperationsValue: Option[
      List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    ] = scala
      .Option(impl.allowedOperations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
            .wrap(item)
        }.toList
      )
    override def statusValue
        : Option[io.github.vigoo.zioaws.licensemanager.model.GrantStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.licensemanager.model.GrantStatus.wrap(value)
        )
    override def statusReasonValue: Option[StatusReasonMessage] =
      scala.Option(impl.statusReason()).map(value => value: StatusReasonMessage)
    override def sourceVersionValue: Option[String] =
      scala.Option(impl.sourceVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateGrantVersionRequest.ReadOnly =
    new Wrapper(impl)
}
