package io.github.vigoo.zioaws.licensemanager.model
import io.github.vigoo.zioaws.licensemanager.model.primitives.{Arn, ClientToken}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateGrantRequest(
    clientToken: ClientToken,
    grantName: String,
    licenseArn: Arn,
    principals: Iterable[Arn],
    homeRegion: String,
    allowedOperations: Iterable[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest = {
    import CreateGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest
      .builder()
      .clientToken(clientToken: java.lang.String)
      .grantName(grantName: java.lang.String)
      .licenseArn(licenseArn: java.lang.String)
      .principals(principals.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .homeRegion(homeRegion: java.lang.String)
      .allowedOperationsWithStrings(allowedOperations.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest.ReadOnly =
    io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest
      .wrap(buildAwsValue())
}
object CreateGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest =
      io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest(
        clientTokenValue,
        grantNameValue,
        licenseArnValue,
        principalsValue,
        homeRegionValue,
        allowedOperationsValue
      )
    def clientTokenValue: ClientToken
    def grantNameValue: String
    def licenseArnValue: Arn
    def principalsValue: List[Arn]
    def homeRegionValue: String
    def allowedOperationsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation]
    def clientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientTokenValue)
    def grantName: ZIO[Any, Nothing, String] = ZIO.succeed(grantNameValue)
    def licenseArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(licenseArnValue)
    def principals: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(principalsValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def allowedOperations: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
    ]] = ZIO.succeed(allowedOperationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest
  ) extends io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest.ReadOnly {
    override def clientTokenValue: ClientToken = impl.clientToken(): ClientToken
    override def grantNameValue: String = impl.grantName(): String
    override def licenseArnValue: Arn = impl.licenseArn(): Arn
    override def principalsValue: List[Arn] = impl
      .principals()
      .asScala
      .map { item =>
        item: Arn
      }
      .toList
    override def homeRegionValue: String = impl.homeRegion(): String
    override def allowedOperationsValue
        : List[io.github.vigoo.zioaws.licensemanager.model.AllowedOperation] =
      impl
        .allowedOperations()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.licensemanager.model.AllowedOperation
            .wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest
  ): io.github.vigoo.zioaws.licensemanager.model.CreateGrantRequest.ReadOnly =
    new Wrapper(impl)
}
