package io.github.vigoo.zioaws.licensemanager
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type Arn = String
    type BoxBoolean = Boolean
    type BoxInteger = Int
    type BoxLong = Long
    type ClientRequestToken = String
    type ClientToken = String
    type DateTime = Instant
    type FilterName = String
    type FilterValue = String
    type ISO8601DateTime = String
    type Integer = Int
    type MaxSize100 = Int
    type ReportGeneratorName = String
    type SignedToken = String
    type StatusReasonMessage = String
    type TokenString = String
  }
  type AllowedOperationList = List[AllowedOperation]
  type ArnList = List[primitives.Arn]
  type ConsumedLicenseSummaryList = List[ConsumedLicenseSummary]
  type EntitlementDataList = List[EntitlementData]
  type EntitlementList = List[Entitlement]
  type EntitlementUsageList = List[EntitlementUsage]
  type FilterList = List[Filter]
  type FilterValues = List[primitives.FilterValue]
  type Filters = List[Filter]
  type GrantList = List[Grant]
  type GrantedLicenseList = List[GrantedLicense]
  type InventoryFilterList = List[InventoryFilter]
  type LicenseConfigurationAssociations = List[LicenseConfigurationAssociation]
  type LicenseConfigurationUsageList = List[LicenseConfigurationUsage]
  type LicenseConfigurations = List[LicenseConfiguration]
  type LicenseList = List[License]
  type LicenseOperationFailureList = List[LicenseOperationFailure]
  type LicenseSpecifications = List[LicenseSpecification]
  type ManagedResourceSummaryList = List[ManagedResourceSummary]
  type MaxSize3StringList = List[String]
  type MetadataList = List[Metadata]
  type PrincipalArnList = List[primitives.Arn]
  type ProductInformationFilterList = List[ProductInformationFilter]
  type ProductInformationList = List[ProductInformation]
  type ReportGeneratorList = List[ReportGenerator]
  type ReportTypeList = List[ReportType]
  type ResourceInventoryList = List[ResourceInventory]
  type StringList = List[String]
  type TagKeyList = List[String]
  type TagList = List[Tag]
  type TokenList = List[TokenData]
}