package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagResourceRequest(resourceArn: String, tags: Iterable[Tag]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.TagResourceRequest.builder().resourceArn(resourceArn: java.lang.String).tags(tags.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagResourceRequest = TagResourceRequest(resourceArnValue, tagsValue.map { item => 
      item.editable
    })
    def resourceArnValue: String
    def tagsValue: List[Tag.ReadOnly]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
      Tag.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
}