package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceInventory(resourceId: scala.Option[String] = None, resourceType: scala.Option[ResourceType] = None, resourceArn: scala.Option[String] = None, platform: scala.Option[String] = None, platformVersion: scala.Option[String] = None, resourceOwningAccountId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ResourceInventory = {
    import ResourceInventory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ResourceInventory.builder().optionallyWith(resourceId.map(value => value: java.lang.String))(_.resourceId).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).optionallyWith(platform.map(value => value: java.lang.String))(_.platform).optionallyWith(platformVersion.map(value => value: java.lang.String))(_.platformVersion).optionallyWith(resourceOwningAccountId.map(value => value: java.lang.String))(_.resourceOwningAccountId).build()
  }
  def asReadOnly: ResourceInventory.ReadOnly = ResourceInventory.wrap(buildAwsValue())
}
object ResourceInventory {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ResourceInventory] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceInventory = ResourceInventory(resourceIdValue.map(value => value), resourceTypeValue.map(value => value), resourceArnValue.map(value => value), platformValue.map(value => value), platformVersionValue.map(value => value), resourceOwningAccountIdValue.map(value => value))
    def resourceIdValue: scala.Option[String]
    def resourceTypeValue: scala.Option[ResourceType]
    def resourceArnValue: scala.Option[String]
    def platformValue: scala.Option[String]
    def platformVersionValue: scala.Option[String]
    def resourceOwningAccountIdValue: scala.Option[String]
    def resourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceId", resourceIdValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def platform: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platform", platformValue)
    def platformVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("platformVersion", platformVersionValue)
    def resourceOwningAccountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceOwningAccountId", resourceOwningAccountIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ResourceInventory) extends ResourceInventory.ReadOnly {
    override def resourceIdValue: scala.Option[String] = scala.Option(impl.resourceId()).map(value => value: String)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def resourceArnValue: scala.Option[String] = scala.Option(impl.resourceArn()).map(value => value: String)
    override def platformValue: scala.Option[String] = scala.Option(impl.platform()).map(value => value: String)
    override def platformVersionValue: scala.Option[String] = scala.Option(impl.platformVersion()).map(value => value: String)
    override def resourceOwningAccountIdValue: scala.Option[String] = scala.Option(impl.resourceOwningAccountId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ResourceInventory): ReadOnly = new Wrapper(impl)
}