package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ManagedResourceSummary(resourceType: scala.Option[ResourceType] = None, associationCount: scala.Option[primitives.BoxLong] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary = {
    import ManagedResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary.builder().optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(associationCount.map(value => value: java.lang.Long))(_.associationCount).build()
  }
  def asReadOnly: ManagedResourceSummary.ReadOnly = ManagedResourceSummary.wrap(buildAwsValue())
}
object ManagedResourceSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ManagedResourceSummary = ManagedResourceSummary(resourceTypeValue.map(value => value), associationCountValue.map(value => value))
    def resourceTypeValue: scala.Option[ResourceType]
    def associationCountValue: scala.Option[primitives.BoxLong]
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def associationCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationCount", associationCountValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary) extends ManagedResourceSummary.ReadOnly {
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def associationCountValue: scala.Option[primitives.BoxLong] = scala.Option(impl.associationCount()).map(value => value: primitives.BoxLong)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ManagedResourceSummary): ReadOnly = new Wrapper(impl)
}