package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListUsageForLicenseConfigurationRequest(licenseConfigurationArn: String, maxResults: scala.Option[primitives.BoxInteger] = None, nextToken: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest = {
    import ListUsageForLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).build()
  }
  def asReadOnly: ListUsageForLicenseConfigurationRequest.ReadOnly = ListUsageForLicenseConfigurationRequest.wrap(buildAwsValue())
}
object ListUsageForLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListUsageForLicenseConfigurationRequest = ListUsageForLicenseConfigurationRequest(licenseConfigurationArnValue, maxResultsValue.map(value => value), nextTokenValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }))
    def licenseConfigurationArnValue: String
    def maxResultsValue: scala.Option[primitives.BoxInteger]
    def nextTokenValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest) extends ListUsageForLicenseConfigurationRequest.ReadOnly {
    override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String
    override def maxResultsValue: scala.Option[primitives.BoxInteger] = scala.Option(impl.maxResults()).map(value => value: primitives.BoxInteger)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListUsageForLicenseConfigurationRequest): ReadOnly = new Wrapper(impl)
}