package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTokensRequest(tokenIds: scala.Option[Iterable[String]] = None, filters: scala.Option[Iterable[Filter]] = None, nextToken: scala.Option[String] = None, maxResults: scala.Option[primitives.MaxSize100] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListTokensRequest = {
    import ListTokensRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListTokensRequest.builder().optionallyWith(tokenIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.tokenIds).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListTokensRequest.ReadOnly = ListTokensRequest.wrap(buildAwsValue())
}
object ListTokensRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListTokensRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTokensRequest = ListTokensRequest(tokenIdsValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def tokenIdsValue: scala.Option[List[String]]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def maxResultsValue: scala.Option[primitives.MaxSize100]
    def tokenIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenIds", tokenIdsValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxSize100] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListTokensRequest) extends ListTokensRequest.ReadOnly {
    override def tokenIdsValue: scala.Option[List[String]] = scala.Option(impl.tokenIds()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: scala.Option[primitives.MaxSize100] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxSize100)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListTokensRequest): ReadOnly = new Wrapper(impl)
}