package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListResourceInventoryResponse(resourceInventoryList: scala.Option[Iterable[ResourceInventory]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse = {
    import ListResourceInventoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse.builder().optionallyWith(resourceInventoryList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.resourceInventoryList).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListResourceInventoryResponse.ReadOnly = ListResourceInventoryResponse.wrap(buildAwsValue())
}
object ListResourceInventoryResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListResourceInventoryResponse = ListResourceInventoryResponse(resourceInventoryListValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def resourceInventoryListValue: scala.Option[List[ResourceInventory.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def resourceInventoryList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ResourceInventory.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceInventoryList", resourceInventoryListValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse) extends ListResourceInventoryResponse.ReadOnly {
    override def resourceInventoryListValue: scala.Option[List[ResourceInventory.ReadOnly]] = scala.Option(impl.resourceInventoryList()).map(value => value.asScala.map { item => 
      ResourceInventory.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListResourceInventoryResponse): ReadOnly = new Wrapper(impl)
}