package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListReceivedGrantsResponse(grants: scala.Option[Iterable[Grant]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse = {
    import ListReceivedGrantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse.builder().optionallyWith(grants.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.grants).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListReceivedGrantsResponse.ReadOnly = ListReceivedGrantsResponse.wrap(buildAwsValue())
}
object ListReceivedGrantsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListReceivedGrantsResponse = ListReceivedGrantsResponse(grantsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def grantsValue: scala.Option[List[Grant.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def grants: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Grant.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("grants", grantsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse) extends ListReceivedGrantsResponse.ReadOnly {
    override def grantsValue: scala.Option[List[Grant.ReadOnly]] = scala.Option(impl.grants()).map(value => value.asScala.map { item => 
      Grant.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListReceivedGrantsResponse): ReadOnly = new Wrapper(impl)
}