package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseSpecificationsForResourceResponse(licenseSpecifications: scala.Option[Iterable[LicenseSpecification]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse = {
    import ListLicenseSpecificationsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse.builder().optionallyWith(licenseSpecifications.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseSpecifications).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListLicenseSpecificationsForResourceResponse.ReadOnly = ListLicenseSpecificationsForResourceResponse.wrap(buildAwsValue())
}
object ListLicenseSpecificationsForResourceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseSpecificationsForResourceResponse = ListLicenseSpecificationsForResourceResponse(licenseSpecificationsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenseSpecifications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseSpecification.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseSpecifications", licenseSpecificationsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse) extends ListLicenseSpecificationsForResourceResponse.ReadOnly {
    override def licenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]] = scala.Option(impl.licenseSpecifications()).map(value => value.asScala.map { item => 
      LicenseSpecification.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse): ReadOnly = new Wrapper(impl)
}