package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseManagerReportGeneratorsResponse(reportGenerators: scala.Option[Iterable[ReportGenerator]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse = {
    import ListLicenseManagerReportGeneratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse.builder().optionallyWith(reportGenerators.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.reportGenerators).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListLicenseManagerReportGeneratorsResponse.ReadOnly = ListLicenseManagerReportGeneratorsResponse.wrap(buildAwsValue())
}
object ListLicenseManagerReportGeneratorsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseManagerReportGeneratorsResponse = ListLicenseManagerReportGeneratorsResponse(reportGeneratorsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def reportGeneratorsValue: scala.Option[List[ReportGenerator.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def reportGenerators: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReportGenerator.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reportGenerators", reportGeneratorsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse) extends ListLicenseManagerReportGeneratorsResponse.ReadOnly {
    override def reportGeneratorsValue: scala.Option[List[ReportGenerator.ReadOnly]] = scala.Option(impl.reportGenerators()).map(value => value.asScala.map { item => 
      ReportGenerator.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse): ReadOnly = new Wrapper(impl)
}