package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LicenseDeletionStatus { def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus }
object LicenseDeletionStatus {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus): LicenseDeletionStatus = value match {
    case software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.PENDING_DELETE =>
      val r = PENDING_DELETE
      r
    case software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends LicenseDeletionStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus = software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_DELETE extends LicenseDeletionStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus = software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.PENDING_DELETE }
  case object DELETED extends LicenseDeletionStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus = software.amazon.awssdk.services.licensemanager.model.LicenseDeletionStatus.DELETED }
}