package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseConfigurationAssociation(resourceArn: scala.Option[String] = None, resourceType: scala.Option[ResourceType] = None, resourceOwnerId: scala.Option[String] = None, associationTime: scala.Option[primitives.DateTime] = None, amiAssociationScope: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation = {
    import LicenseConfigurationAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation.builder().optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(_.resourceOwnerId).optionallyWith(associationTime.map(value => value: java.time.Instant))(_.associationTime).optionallyWith(amiAssociationScope.map(value => value: java.lang.String))(_.amiAssociationScope).build()
  }
  def asReadOnly: LicenseConfigurationAssociation.ReadOnly = LicenseConfigurationAssociation.wrap(buildAwsValue())
}
object LicenseConfigurationAssociation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseConfigurationAssociation = LicenseConfigurationAssociation(resourceArnValue.map(value => value), resourceTypeValue.map(value => value), resourceOwnerIdValue.map(value => value), associationTimeValue.map(value => value), amiAssociationScopeValue.map(value => value))
    def resourceArnValue: scala.Option[String]
    def resourceTypeValue: scala.Option[ResourceType]
    def resourceOwnerIdValue: scala.Option[String]
    def associationTimeValue: scala.Option[primitives.DateTime]
    def amiAssociationScopeValue: scala.Option[String]
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceOwnerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def associationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationTime", associationTimeValue)
    def amiAssociationScope: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("amiAssociationScope", amiAssociationScopeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation) extends LicenseConfigurationAssociation.ReadOnly {
    override def resourceArnValue: scala.Option[String] = scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def resourceOwnerIdValue: scala.Option[String] = scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def associationTimeValue: scala.Option[primitives.DateTime] = scala.Option(impl.associationTime()).map(value => value: primitives.DateTime)
    override def amiAssociationScopeValue: scala.Option[String] = scala.Option(impl.amiAssociationScope()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationAssociation): ReadOnly = new Wrapper(impl)
}