package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseConfiguration(licenseConfigurationId: scala.Option[String] = None, licenseConfigurationArn: scala.Option[String] = None, name: scala.Option[String] = None, description: scala.Option[String] = None, licenseCountingType: scala.Option[LicenseCountingType] = None, licenseRules: scala.Option[Iterable[String]] = None, licenseCount: scala.Option[primitives.BoxLong] = None, licenseCountHardLimit: scala.Option[primitives.BoxBoolean] = None, disassociateWhenNotFound: scala.Option[primitives.BoxBoolean] = None, consumedLicenses: scala.Option[primitives.BoxLong] = None, status: scala.Option[String] = None, ownerAccountId: scala.Option[String] = None, consumedLicenseSummaryList: scala.Option[Iterable[ConsumedLicenseSummary]] = None, managedResourceSummaryList: scala.Option[Iterable[ManagedResourceSummary]] = None, productInformationList: scala.Option[Iterable[ProductInformation]] = None, automatedDiscoveryInformation: scala.Option[AutomatedDiscoveryInformation] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration = {
    import LicenseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration.builder().optionallyWith(licenseConfigurationId.map(value => value: java.lang.String))(_.licenseConfigurationId).optionallyWith(licenseConfigurationArn.map(value => value: java.lang.String))(_.licenseConfigurationArn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(licenseCountingType.map(value => value.unwrap))(_.licenseCountingType).optionallyWith(licenseRules.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.licenseRules).optionallyWith(licenseCount.map(value => value: java.lang.Long))(_.licenseCount).optionallyWith(licenseCountHardLimit.map(value => value: java.lang.Boolean))(_.licenseCountHardLimit).optionallyWith(disassociateWhenNotFound.map(value => value: java.lang.Boolean))(_.disassociateWhenNotFound).optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(_.consumedLicenses).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(ownerAccountId.map(value => value: java.lang.String))(_.ownerAccountId).optionallyWith(consumedLicenseSummaryList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.consumedLicenseSummaryList).optionallyWith(managedResourceSummaryList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.managedResourceSummaryList).optionallyWith(productInformationList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.productInformationList).optionallyWith(automatedDiscoveryInformation.map(value => value.buildAwsValue()))(_.automatedDiscoveryInformation).build()
  }
  def asReadOnly: LicenseConfiguration.ReadOnly = LicenseConfiguration.wrap(buildAwsValue())
}
object LicenseConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseConfiguration = LicenseConfiguration(licenseConfigurationIdValue.map(value => value), licenseConfigurationArnValue.map(value => value), nameValue.map(value => value), descriptionValue.map(value => value), licenseCountingTypeValue.map(value => value), licenseRulesValue.map(value => value), licenseCountValue.map(value => value), licenseCountHardLimitValue.map(value => value), disassociateWhenNotFoundValue.map(value => value), consumedLicensesValue.map(value => value), statusValue.map(value => value), ownerAccountIdValue.map(value => value), consumedLicenseSummaryListValue.map(value => value.map { item => 
      item.editable
    }), managedResourceSummaryListValue.map(value => value.map { item => 
      item.editable
    }), productInformationListValue.map(value => value.map { item => 
      item.editable
    }), automatedDiscoveryInformationValue.map(value => value.editable))
    def licenseConfigurationIdValue: scala.Option[String]
    def licenseConfigurationArnValue: scala.Option[String]
    def nameValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def licenseCountingTypeValue: scala.Option[LicenseCountingType]
    def licenseRulesValue: scala.Option[List[String]]
    def licenseCountValue: scala.Option[primitives.BoxLong]
    def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean]
    def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean]
    def consumedLicensesValue: scala.Option[primitives.BoxLong]
    def statusValue: scala.Option[String]
    def ownerAccountIdValue: scala.Option[String]
    def consumedLicenseSummaryListValue: scala.Option[List[ConsumedLicenseSummary.ReadOnly]]
    def managedResourceSummaryListValue: scala.Option[List[ManagedResourceSummary.ReadOnly]]
    def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]]
    def automatedDiscoveryInformationValue: scala.Option[AutomatedDiscoveryInformation.ReadOnly]
    def licenseConfigurationId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationId", licenseConfigurationIdValue)
    def licenseConfigurationArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationArn", licenseConfigurationArnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def licenseCountingType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseCountingType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCountingType", licenseCountingTypeValue)
    def licenseRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def licenseCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def disassociateWhenNotFound: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disassociateWhenNotFound", disassociateWhenNotFoundValue)
    def consumedLicenses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def ownerAccountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerAccountId", ownerAccountIdValue)
    def consumedLicenseSummaryList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ConsumedLicenseSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("consumedLicenseSummaryList", consumedLicenseSummaryListValue)
    def managedResourceSummaryList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ManagedResourceSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("managedResourceSummaryList", managedResourceSummaryListValue)
    def productInformationList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProductInformation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productInformationList", productInformationListValue)
    def automatedDiscoveryInformation: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AutomatedDiscoveryInformation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("automatedDiscoveryInformation", automatedDiscoveryInformationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration) extends LicenseConfiguration.ReadOnly {
    override def licenseConfigurationIdValue: scala.Option[String] = scala.Option(impl.licenseConfigurationId()).map(value => value: String)
    override def licenseConfigurationArnValue: scala.Option[String] = scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def licenseCountingTypeValue: scala.Option[LicenseCountingType] = scala.Option(impl.licenseCountingType()).map(value => LicenseCountingType.wrap(value))
    override def licenseRulesValue: scala.Option[List[String]] = scala.Option(impl.licenseRules()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def licenseCountValue: scala.Option[primitives.BoxLong] = scala.Option(impl.licenseCount()).map(value => value: primitives.BoxLong)
    override def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.licenseCountHardLimit()).map(value => value: primitives.BoxBoolean)
    override def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.disassociateWhenNotFound()).map(value => value: primitives.BoxBoolean)
    override def consumedLicensesValue: scala.Option[primitives.BoxLong] = scala.Option(impl.consumedLicenses()).map(value => value: primitives.BoxLong)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def ownerAccountIdValue: scala.Option[String] = scala.Option(impl.ownerAccountId()).map(value => value: String)
    override def consumedLicenseSummaryListValue: scala.Option[List[ConsumedLicenseSummary.ReadOnly]] = scala.Option(impl.consumedLicenseSummaryList()).map(value => value.asScala.map { item => 
      ConsumedLicenseSummary.wrap(item)
    }.toList)
    override def managedResourceSummaryListValue: scala.Option[List[ManagedResourceSummary.ReadOnly]] = scala.Option(impl.managedResourceSummaryList()).map(value => value.asScala.map { item => 
      ManagedResourceSummary.wrap(item)
    }.toList)
    override def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]] = scala.Option(impl.productInformationList()).map(value => value.asScala.map { item => 
      ProductInformation.wrap(item)
    }.toList)
    override def automatedDiscoveryInformationValue: scala.Option[AutomatedDiscoveryInformation.ReadOnly] = scala.Option(impl.automatedDiscoveryInformation()).map(value => AutomatedDiscoveryInformation.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfiguration): ReadOnly = new Wrapper(impl)
}