package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait InventoryFilterCondition { def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition }
object InventoryFilterCondition {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition): InventoryFilterCondition = value match {
    case software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
    case software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.BEGINS_WITH =>
      val r = BEGINS_WITH
      r
    case software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.CONTAINS =>
      val r = CONTAINS
      r
  }
  case object unknownToSdkVersion extends InventoryFilterCondition { override def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition = software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.UNKNOWN_TO_SDK_VERSION }
  case object EQUALS extends InventoryFilterCondition { override def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition = software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.EQUALS }
  case object NOT_EQUALS extends InventoryFilterCondition { override def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition = software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.NOT_EQUALS }
  case object BEGINS_WITH extends InventoryFilterCondition { override def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition = software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.BEGINS_WITH }
  case object CONTAINS extends InventoryFilterCondition { override def unwrap: software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition = software.amazon.awssdk.services.licensemanager.model.InventoryFilterCondition.CONTAINS }
}