package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InventoryFilter(name: String, condition: InventoryFilterCondition, value: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.InventoryFilter = {
    import InventoryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.InventoryFilter.builder().name(name: java.lang.String).condition(condition.unwrap).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: InventoryFilter.ReadOnly = InventoryFilter.wrap(buildAwsValue())
}
object InventoryFilter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.InventoryFilter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InventoryFilter = InventoryFilter(nameValue, conditionValue, valueValue.map(value => value))
    def nameValue: String
    def conditionValue: InventoryFilterCondition
    def valueValue: scala.Option[String]
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def condition: ZIO[Any, Nothing, InventoryFilterCondition] = ZIO.succeed(conditionValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.InventoryFilter) extends InventoryFilter.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def conditionValue: InventoryFilterCondition = InventoryFilterCondition.wrap(impl.condition())
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.InventoryFilter): ReadOnly = new Wrapper(impl)
}