package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GrantedLicense(licenseArn: scala.Option[primitives.Arn] = None, licenseName: scala.Option[String] = None, productName: scala.Option[String] = None, productSKU: scala.Option[String] = None, issuer: scala.Option[IssuerDetails] = None, homeRegion: scala.Option[String] = None, status: scala.Option[LicenseStatus] = None, validity: scala.Option[DatetimeRange] = None, beneficiary: scala.Option[String] = None, entitlements: scala.Option[Iterable[Entitlement]] = None, consumptionConfiguration: scala.Option[ConsumptionConfiguration] = None, licenseMetadata: scala.Option[Iterable[Metadata]] = None, createTime: scala.Option[primitives.ISO8601DateTime] = None, version: scala.Option[String] = None, receivedMetadata: scala.Option[ReceivedMetadata] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GrantedLicense = {
    import GrantedLicense.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GrantedLicense.builder().optionallyWith(licenseArn.map(value => value: java.lang.String))(_.licenseArn).optionallyWith(licenseName.map(value => value: java.lang.String))(_.licenseName).optionallyWith(productName.map(value => value: java.lang.String))(_.productName).optionallyWith(productSKU.map(value => value: java.lang.String))(_.productSKU).optionallyWith(issuer.map(value => value.buildAwsValue()))(_.issuer).optionallyWith(homeRegion.map(value => value: java.lang.String))(_.homeRegion).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(validity.map(value => value.buildAwsValue()))(_.validity).optionallyWith(beneficiary.map(value => value: java.lang.String))(_.beneficiary).optionallyWith(entitlements.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.entitlements).optionallyWith(consumptionConfiguration.map(value => value.buildAwsValue()))(_.consumptionConfiguration).optionallyWith(licenseMetadata.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseMetadata).optionallyWith(createTime.map(value => value: java.lang.String))(_.createTime).optionallyWith(version.map(value => value: java.lang.String))(_.version).optionallyWith(receivedMetadata.map(value => value.buildAwsValue()))(_.receivedMetadata).build()
  }
  def asReadOnly: GrantedLicense.ReadOnly = GrantedLicense.wrap(buildAwsValue())
}
object GrantedLicense {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GrantedLicense] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GrantedLicense = GrantedLicense(licenseArnValue.map(value => value), licenseNameValue.map(value => value), productNameValue.map(value => value), productSKUValue.map(value => value), issuerValue.map(value => value.editable), homeRegionValue.map(value => value), statusValue.map(value => value), validityValue.map(value => value.editable), beneficiaryValue.map(value => value), entitlementsValue.map(value => value.map { item => 
      item.editable
    }), consumptionConfigurationValue.map(value => value.editable), licenseMetadataValue.map(value => value.map { item => 
      item.editable
    }), createTimeValue.map(value => value), versionValue.map(value => value), receivedMetadataValue.map(value => value.editable))
    def licenseArnValue: scala.Option[primitives.Arn]
    def licenseNameValue: scala.Option[String]
    def productNameValue: scala.Option[String]
    def productSKUValue: scala.Option[String]
    def issuerValue: scala.Option[IssuerDetails.ReadOnly]
    def homeRegionValue: scala.Option[String]
    def statusValue: scala.Option[LicenseStatus]
    def validityValue: scala.Option[DatetimeRange.ReadOnly]
    def beneficiaryValue: scala.Option[String]
    def entitlementsValue: scala.Option[List[Entitlement.ReadOnly]]
    def consumptionConfigurationValue: scala.Option[ConsumptionConfiguration.ReadOnly]
    def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]]
    def createTimeValue: scala.Option[primitives.ISO8601DateTime]
    def versionValue: scala.Option[String]
    def receivedMetadataValue: scala.Option[ReceivedMetadata.ReadOnly]
    def licenseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def licenseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseName", licenseNameValue)
    def productName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productName", productNameValue)
    def productSKU: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productSKU", productSKUValue)
    def issuer: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IssuerDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuer", issuerValue)
    def homeRegion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("homeRegion", homeRegionValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def validity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DatetimeRange.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validity", validityValue)
    def beneficiary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
    def entitlements: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Entitlement.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("entitlements", entitlementsValue)
    def consumptionConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConsumptionConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("consumptionConfiguration", consumptionConfigurationValue)
    def licenseMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def createTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createTime", createTimeValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
    def receivedMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReceivedMetadata.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("receivedMetadata", receivedMetadataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GrantedLicense) extends GrantedLicense.ReadOnly {
    override def licenseArnValue: scala.Option[primitives.Arn] = scala.Option(impl.licenseArn()).map(value => value: primitives.Arn)
    override def licenseNameValue: scala.Option[String] = scala.Option(impl.licenseName()).map(value => value: String)
    override def productNameValue: scala.Option[String] = scala.Option(impl.productName()).map(value => value: String)
    override def productSKUValue: scala.Option[String] = scala.Option(impl.productSKU()).map(value => value: String)
    override def issuerValue: scala.Option[IssuerDetails.ReadOnly] = scala.Option(impl.issuer()).map(value => IssuerDetails.wrap(value))
    override def homeRegionValue: scala.Option[String] = scala.Option(impl.homeRegion()).map(value => value: String)
    override def statusValue: scala.Option[LicenseStatus] = scala.Option(impl.status()).map(value => LicenseStatus.wrap(value))
    override def validityValue: scala.Option[DatetimeRange.ReadOnly] = scala.Option(impl.validity()).map(value => DatetimeRange.wrap(value))
    override def beneficiaryValue: scala.Option[String] = scala.Option(impl.beneficiary()).map(value => value: String)
    override def entitlementsValue: scala.Option[List[Entitlement.ReadOnly]] = scala.Option(impl.entitlements()).map(value => value.asScala.map { item => 
      Entitlement.wrap(item)
    }.toList)
    override def consumptionConfigurationValue: scala.Option[ConsumptionConfiguration.ReadOnly] = scala.Option(impl.consumptionConfiguration()).map(value => ConsumptionConfiguration.wrap(value))
    override def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.licenseMetadata()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
    override def createTimeValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.createTime()).map(value => value: primitives.ISO8601DateTime)
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
    override def receivedMetadataValue: scala.Option[ReceivedMetadata.ReadOnly] = scala.Option(impl.receivedMetadata()).map(value => ReceivedMetadata.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GrantedLicense): ReadOnly = new Wrapper(impl)
}