package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Filter(name: scala.Option[primitives.FilterName] = None, values: scala.Option[Iterable[primitives.FilterValue]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Filter.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(values.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.values).build()
  }
  def asReadOnly: Filter.ReadOnly = Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.Filter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Filter = Filter(nameValue.map(value => value), valuesValue.map(value => value))
    def nameValue: scala.Option[primitives.FilterName]
    def valuesValue: scala.Option[List[primitives.FilterValue]]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.FilterName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.FilterValue]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.Filter) extends Filter.ReadOnly {
    override def nameValue: scala.Option[primitives.FilterName] = scala.Option(impl.name()).map(value => value: primitives.FilterName)
    override def valuesValue: scala.Option[List[primitives.FilterValue]] = scala.Option(impl.values()).map(value => value.asScala.map { item => 
      item: primitives.FilterValue
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.Filter): ReadOnly = new Wrapper(impl)
}