package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExtendLicenseConsumptionRequest(licenseConsumptionToken: String, dryRun: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest = {
    import ExtendLicenseConsumptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest.builder().licenseConsumptionToken(licenseConsumptionToken: java.lang.String).optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun).build()
  }
  def asReadOnly: ExtendLicenseConsumptionRequest.ReadOnly = ExtendLicenseConsumptionRequest.wrap(buildAwsValue())
}
object ExtendLicenseConsumptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExtendLicenseConsumptionRequest = ExtendLicenseConsumptionRequest(licenseConsumptionTokenValue, dryRunValue.map(value => value))
    def licenseConsumptionTokenValue: String
    def dryRunValue: scala.Option[Boolean]
    def licenseConsumptionToken: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConsumptionTokenValue)
    def dryRun: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dryRun", dryRunValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest) extends ExtendLicenseConsumptionRequest.ReadOnly {
    override def licenseConsumptionTokenValue: String = impl.licenseConsumptionToken(): String
    override def dryRunValue: scala.Option[Boolean] = scala.Option(impl.dryRun()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionRequest): ReadOnly = new Wrapper(impl)
}