package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteGrantRequest(grantArn: primitives.Arn, statusReason: scala.Option[primitives.StatusReasonMessage] = None, version: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest = {
    import DeleteGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest.builder().grantArn(grantArn: java.lang.String).optionallyWith(statusReason.map(value => value: java.lang.String))(_.statusReason).version(version: java.lang.String).build()
  }
  def asReadOnly: DeleteGrantRequest.ReadOnly = DeleteGrantRequest.wrap(buildAwsValue())
}
object DeleteGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteGrantRequest = DeleteGrantRequest(grantArnValue, statusReasonValue.map(value => value), versionValue)
    def grantArnValue: primitives.Arn
    def statusReasonValue: scala.Option[primitives.StatusReasonMessage]
    def versionValue: String
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
    def statusReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StatusReasonMessage] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def version: ZIO[Any, Nothing, String] = ZIO.succeed(versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest) extends DeleteGrantRequest.ReadOnly {
    override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn
    override def statusReasonValue: scala.Option[primitives.StatusReasonMessage] = scala.Option(impl.statusReason()).map(value => value: primitives.StatusReasonMessage)
    override def versionValue: String = impl.version(): String
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest): ReadOnly = new Wrapper(impl)
}