package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateTokenResponse(tokenId: scala.Option[String] = None, tokenType: scala.Option[TokenType] = None, token: scala.Option[primitives.TokenString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse = {
    import CreateTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse.builder().optionallyWith(tokenId.map(value => value: java.lang.String))(_.tokenId).optionallyWith(tokenType.map(value => value.unwrap))(_.tokenType).optionallyWith(token.map(value => value: java.lang.String))(_.token).build()
  }
  def asReadOnly: CreateTokenResponse.ReadOnly = CreateTokenResponse.wrap(buildAwsValue())
}
object CreateTokenResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateTokenResponse = CreateTokenResponse(tokenIdValue.map(value => value), tokenTypeValue.map(value => value), tokenValue.map(value => value))
    def tokenIdValue: scala.Option[String]
    def tokenTypeValue: scala.Option[TokenType]
    def tokenValue: scala.Option[primitives.TokenString]
    def tokenId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenId", tokenIdValue)
    def tokenType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenType", tokenTypeValue)
    def token: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TokenString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("token", tokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse) extends CreateTokenResponse.ReadOnly {
    override def tokenIdValue: scala.Option[String] = scala.Option(impl.tokenId()).map(value => value: String)
    override def tokenTypeValue: scala.Option[TokenType] = scala.Option(impl.tokenType()).map(value => TokenType.wrap(value))
    override def tokenValue: scala.Option[primitives.TokenString] = scala.Option(impl.token()).map(value => value: primitives.TokenString)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenResponse): ReadOnly = new Wrapper(impl)
}