package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateTokenRequest(licenseArn: primitives.Arn, roleArns: scala.Option[Iterable[primitives.Arn]] = None, expirationInDays: scala.Option[primitives.Integer] = None, tokenProperties: scala.Option[Iterable[String]] = None, clientToken: primitives.ClientToken) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest = {
    import CreateTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest.builder().licenseArn(licenseArn: java.lang.String).optionallyWith(roleArns.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.roleArns).optionallyWith(expirationInDays.map(value => value: java.lang.Integer))(_.expirationInDays).optionallyWith(tokenProperties.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.tokenProperties).clientToken(clientToken: java.lang.String).build()
  }
  def asReadOnly: CreateTokenRequest.ReadOnly = CreateTokenRequest.wrap(buildAwsValue())
}
object CreateTokenRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateTokenRequest = CreateTokenRequest(licenseArnValue, roleArnsValue.map(value => value), expirationInDaysValue.map(value => value), tokenPropertiesValue.map(value => value), clientTokenValue)
    def licenseArnValue: primitives.Arn
    def roleArnsValue: scala.Option[List[primitives.Arn]]
    def expirationInDaysValue: scala.Option[primitives.Integer]
    def tokenPropertiesValue: scala.Option[List[String]]
    def clientTokenValue: primitives.ClientToken
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def roleArns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Arn]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArns", roleArnsValue)
    def expirationInDays: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expirationInDays", expirationInDaysValue)
    def tokenProperties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientToken] = ZIO.succeed(clientTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest) extends CreateTokenRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def roleArnsValue: scala.Option[List[primitives.Arn]] = scala.Option(impl.roleArns()).map(value => value.asScala.map { item => 
      item: primitives.Arn
    }.toList)
    override def expirationInDaysValue: scala.Option[primitives.Integer] = scala.Option(impl.expirationInDays()).map(value => value: primitives.Integer)
    override def tokenPropertiesValue: scala.Option[List[String]] = scala.Option(impl.tokenProperties()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def clientTokenValue: primitives.ClientToken = impl.clientToken(): primitives.ClientToken
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateTokenRequest): ReadOnly = new Wrapper(impl)
}