package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseVersionResponse(licenseArn: scala.Option[primitives.Arn] = None, version: scala.Option[String] = None, status: scala.Option[LicenseStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse = {
    import CreateLicenseVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse.builder().optionallyWith(licenseArn.map(value => value: java.lang.String))(_.licenseArn).optionallyWith(version.map(value => value: java.lang.String))(_.version).optionallyWith(status.map(value => value.unwrap))(_.status).build()
  }
  def asReadOnly: CreateLicenseVersionResponse.ReadOnly = CreateLicenseVersionResponse.wrap(buildAwsValue())
}
object CreateLicenseVersionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseVersionResponse = CreateLicenseVersionResponse(licenseArnValue.map(value => value), versionValue.map(value => value), statusValue.map(value => value))
    def licenseArnValue: scala.Option[primitives.Arn]
    def versionValue: scala.Option[String]
    def statusValue: scala.Option[LicenseStatus]
    def licenseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse) extends CreateLicenseVersionResponse.ReadOnly {
    override def licenseArnValue: scala.Option[primitives.Arn] = scala.Option(impl.licenseArn()).map(value => value: primitives.Arn)
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
    override def statusValue: scala.Option[LicenseStatus] = scala.Option(impl.status()).map(value => LicenseStatus.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionResponse): ReadOnly = new Wrapper(impl)
}