package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseResponse(licenseArn: scala.Option[primitives.Arn] = None, status: scala.Option[LicenseStatus] = None, version: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse = {
    import CreateLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse.builder().optionallyWith(licenseArn.map(value => value: java.lang.String))(_.licenseArn).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(version.map(value => value: java.lang.String))(_.version).build()
  }
  def asReadOnly: CreateLicenseResponse.ReadOnly = CreateLicenseResponse.wrap(buildAwsValue())
}
object CreateLicenseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseResponse = CreateLicenseResponse(licenseArnValue.map(value => value), statusValue.map(value => value), versionValue.map(value => value))
    def licenseArnValue: scala.Option[primitives.Arn]
    def statusValue: scala.Option[LicenseStatus]
    def versionValue: scala.Option[String]
    def licenseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Arn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse) extends CreateLicenseResponse.ReadOnly {
    override def licenseArnValue: scala.Option[primitives.Arn] = scala.Option(impl.licenseArn()).map(value => value: primitives.Arn)
    override def statusValue: scala.Option[LicenseStatus] = scala.Option(impl.status()).map(value => LicenseStatus.wrap(value))
    override def versionValue: scala.Option[String] = scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseResponse): ReadOnly = new Wrapper(impl)
}