package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseConfigurationResponse(licenseConfigurationArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse = {
    import CreateLicenseConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse.builder().optionallyWith(licenseConfigurationArn.map(value => value: java.lang.String))(_.licenseConfigurationArn).build()
  }
  def asReadOnly: CreateLicenseConfigurationResponse.ReadOnly = CreateLicenseConfigurationResponse.wrap(buildAwsValue())
}
object CreateLicenseConfigurationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseConfigurationResponse = CreateLicenseConfigurationResponse(licenseConfigurationArnValue.map(value => value))
    def licenseConfigurationArnValue: scala.Option[String]
    def licenseConfigurationArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationArn", licenseConfigurationArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse) extends CreateLicenseConfigurationResponse.ReadOnly { override def licenseConfigurationArnValue: scala.Option[String] = scala.Option(impl.licenseConfigurationArn()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseConfigurationResponse): ReadOnly = new Wrapper(impl)
}