package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGrantVersionRequest(clientToken: primitives.ClientToken, grantArn: primitives.Arn, grantName: scala.Option[String] = None, allowedOperations: scala.Option[Iterable[AllowedOperation]] = None, status: scala.Option[GrantStatus] = None, statusReason: scala.Option[primitives.StatusReasonMessage] = None, sourceVersion: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest = {
    import CreateGrantVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest.builder().clientToken(clientToken: java.lang.String).grantArn(grantArn: java.lang.String).optionallyWith(grantName.map(value => value: java.lang.String))(_.grantName).optionallyWith(allowedOperations.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.allowedOperationsWithStrings).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(statusReason.map(value => value: java.lang.String))(_.statusReason).optionallyWith(sourceVersion.map(value => value: java.lang.String))(_.sourceVersion).build()
  }
  def asReadOnly: CreateGrantVersionRequest.ReadOnly = CreateGrantVersionRequest.wrap(buildAwsValue())
}
object CreateGrantVersionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGrantVersionRequest = CreateGrantVersionRequest(clientTokenValue, grantArnValue, grantNameValue.map(value => value), allowedOperationsValue.map(value => value), statusValue.map(value => value), statusReasonValue.map(value => value), sourceVersionValue.map(value => value))
    def clientTokenValue: primitives.ClientToken
    def grantArnValue: primitives.Arn
    def grantNameValue: scala.Option[String]
    def allowedOperationsValue: scala.Option[List[AllowedOperation]]
    def statusValue: scala.Option[GrantStatus]
    def statusReasonValue: scala.Option[primitives.StatusReasonMessage]
    def sourceVersionValue: scala.Option[String]
    def clientToken: ZIO[Any, Nothing, primitives.ClientToken] = ZIO.succeed(clientTokenValue)
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
    def grantName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("grantName", grantNameValue)
    def allowedOperations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AllowedOperation]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedOperations", allowedOperationsValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GrantStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def statusReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.StatusReasonMessage] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def sourceVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceVersion", sourceVersionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest) extends CreateGrantVersionRequest.ReadOnly {
    override def clientTokenValue: primitives.ClientToken = impl.clientToken(): primitives.ClientToken
    override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn
    override def grantNameValue: scala.Option[String] = scala.Option(impl.grantName()).map(value => value: String)
    override def allowedOperationsValue: scala.Option[List[AllowedOperation]] = scala.Option(impl.allowedOperations()).map(value => value.asScala.map { item => 
      AllowedOperation.wrap(item)
    }.toList)
    override def statusValue: scala.Option[GrantStatus] = scala.Option(impl.status()).map(value => GrantStatus.wrap(value))
    override def statusReasonValue: scala.Option[primitives.StatusReasonMessage] = scala.Option(impl.statusReason()).map(value => value: primitives.StatusReasonMessage)
    override def sourceVersionValue: scala.Option[String] = scala.Option(impl.sourceVersion()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantVersionRequest): ReadOnly = new Wrapper(impl)
}