package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateServiceSettingsRequest(s3BucketArn: scala.Option[String] = None, snsTopicArn: scala.Option[String] = None, organizationConfiguration: scala.Option[OrganizationConfiguration] = None, enableCrossAccountsDiscovery: scala.Option[primitives.BoxBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest = {
    import UpdateServiceSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest.builder().optionallyWith(s3BucketArn.map(value => value: java.lang.String))(_.s3BucketArn).optionallyWith(snsTopicArn.map(value => value: java.lang.String))(_.snsTopicArn).optionallyWith(organizationConfiguration.map(value => value.buildAwsValue()))(_.organizationConfiguration).optionallyWith(enableCrossAccountsDiscovery.map(value => value: java.lang.Boolean))(_.enableCrossAccountsDiscovery).build()
  }
  def asReadOnly: UpdateServiceSettingsRequest.ReadOnly = UpdateServiceSettingsRequest.wrap(buildAwsValue())
}
object UpdateServiceSettingsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateServiceSettingsRequest = UpdateServiceSettingsRequest(s3BucketArnValue.map(value => value), snsTopicArnValue.map(value => value), organizationConfigurationValue.map(value => value.editable), enableCrossAccountsDiscoveryValue.map(value => value))
    def s3BucketArnValue: scala.Option[String]
    def snsTopicArnValue: scala.Option[String]
    def organizationConfigurationValue: scala.Option[OrganizationConfiguration.ReadOnly]
    def enableCrossAccountsDiscoveryValue: scala.Option[primitives.BoxBoolean]
    def s3BucketArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3BucketArn", s3BucketArnValue)
    def snsTopicArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
    def organizationConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OrganizationConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organizationConfiguration", organizationConfigurationValue)
    def enableCrossAccountsDiscovery: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCrossAccountsDiscovery", enableCrossAccountsDiscoveryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest) extends UpdateServiceSettingsRequest.ReadOnly {
    override def s3BucketArnValue: scala.Option[String] = scala.Option(impl.s3BucketArn()).map(value => value: String)
    override def snsTopicArnValue: scala.Option[String] = scala.Option(impl.snsTopicArn()).map(value => value: String)
    override def organizationConfigurationValue: scala.Option[OrganizationConfiguration.ReadOnly] = scala.Option(impl.organizationConfiguration()).map(value => OrganizationConfiguration.wrap(value))
    override def enableCrossAccountsDiscoveryValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.enableCrossAccountsDiscovery()).map(value => value: primitives.BoxBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.UpdateServiceSettingsRequest): ReadOnly = new Wrapper(impl)
}