package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateLicenseSpecificationsForResourceRequest(resourceArn: String, addLicenseSpecifications: scala.Option[Iterable[LicenseSpecification]] = None, removeLicenseSpecifications: scala.Option[Iterable[LicenseSpecification]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest = {
    import UpdateLicenseSpecificationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest.builder().resourceArn(resourceArn: java.lang.String).optionallyWith(addLicenseSpecifications.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addLicenseSpecifications).optionallyWith(removeLicenseSpecifications.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.removeLicenseSpecifications).build()
  }
  def asReadOnly: UpdateLicenseSpecificationsForResourceRequest.ReadOnly = UpdateLicenseSpecificationsForResourceRequest.wrap(buildAwsValue())
}
object UpdateLicenseSpecificationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateLicenseSpecificationsForResourceRequest = UpdateLicenseSpecificationsForResourceRequest(resourceArnValue, addLicenseSpecificationsValue.map(value => value.map { item => 
      item.editable
    }), removeLicenseSpecificationsValue.map(value => value.map { item => 
      item.editable
    }))
    def resourceArnValue: String
    def addLicenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]]
    def removeLicenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]]
    def resourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArnValue)
    def addLicenseSpecifications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseSpecification.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addLicenseSpecifications", addLicenseSpecificationsValue)
    def removeLicenseSpecifications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseSpecification.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("removeLicenseSpecifications", removeLicenseSpecificationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest) extends UpdateLicenseSpecificationsForResourceRequest.ReadOnly {
    override def resourceArnValue: String = impl.resourceArn(): String
    override def addLicenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]] = scala.Option(impl.addLicenseSpecifications()).map(value => value.asScala.map { item => 
      LicenseSpecification.wrap(item)
    }.toList)
    override def removeLicenseSpecificationsValue: scala.Option[List[LicenseSpecification.ReadOnly]] = scala.Option(impl.removeLicenseSpecifications()).map(value => value.asScala.map { item => 
      LicenseSpecification.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest): ReadOnly = new Wrapper(impl)
}