package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateLicenseConfigurationRequest(licenseConfigurationArn: String, licenseConfigurationStatus: scala.Option[LicenseConfigurationStatus] = None, licenseRules: scala.Option[Iterable[String]] = None, licenseCount: scala.Option[primitives.BoxLong] = None, licenseCountHardLimit: scala.Option[primitives.BoxBoolean] = None, name: scala.Option[String] = None, description: scala.Option[String] = None, productInformationList: scala.Option[Iterable[ProductInformation]] = None, disassociateWhenNotFound: scala.Option[primitives.BoxBoolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest = {
    import UpdateLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).optionallyWith(licenseConfigurationStatus.map(value => value.unwrap))(_.licenseConfigurationStatus).optionallyWith(licenseRules.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.licenseRules).optionallyWith(licenseCount.map(value => value: java.lang.Long))(_.licenseCount).optionallyWith(licenseCountHardLimit.map(value => value: java.lang.Boolean))(_.licenseCountHardLimit).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(productInformationList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.productInformationList).optionallyWith(disassociateWhenNotFound.map(value => value: java.lang.Boolean))(_.disassociateWhenNotFound).build()
  }
  def asReadOnly: UpdateLicenseConfigurationRequest.ReadOnly = UpdateLicenseConfigurationRequest.wrap(buildAwsValue())
}
object UpdateLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateLicenseConfigurationRequest = UpdateLicenseConfigurationRequest(licenseConfigurationArnValue, licenseConfigurationStatusValue.map(value => value), licenseRulesValue.map(value => value), licenseCountValue.map(value => value), licenseCountHardLimitValue.map(value => value), nameValue.map(value => value), descriptionValue.map(value => value), productInformationListValue.map(value => value.map { item => 
      item.editable
    }), disassociateWhenNotFoundValue.map(value => value))
    def licenseConfigurationArnValue: String
    def licenseConfigurationStatusValue: scala.Option[LicenseConfigurationStatus]
    def licenseRulesValue: scala.Option[List[String]]
    def licenseCountValue: scala.Option[primitives.BoxLong]
    def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean]
    def nameValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]]
    def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
    def licenseConfigurationStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LicenseConfigurationStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurationStatus", licenseConfigurationStatusValue)
    def licenseRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseRules", licenseRulesValue)
    def licenseCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCount", licenseCountValue)
    def licenseCountHardLimit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseCountHardLimit", licenseCountHardLimitValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def productInformationList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProductInformation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productInformationList", productInformationListValue)
    def disassociateWhenNotFound: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxBoolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disassociateWhenNotFound", disassociateWhenNotFoundValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest) extends UpdateLicenseConfigurationRequest.ReadOnly {
    override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String
    override def licenseConfigurationStatusValue: scala.Option[LicenseConfigurationStatus] = scala.Option(impl.licenseConfigurationStatus()).map(value => LicenseConfigurationStatus.wrap(value))
    override def licenseRulesValue: scala.Option[List[String]] = scala.Option(impl.licenseRules()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def licenseCountValue: scala.Option[primitives.BoxLong] = scala.Option(impl.licenseCount()).map(value => value: primitives.BoxLong)
    override def licenseCountHardLimitValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.licenseCountHardLimit()).map(value => value: primitives.BoxBoolean)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def productInformationListValue: scala.Option[List[ProductInformation.ReadOnly]] = scala.Option(impl.productInformationList()).map(value => value.asScala.map { item => 
      ProductInformation.wrap(item)
    }.toList)
    override def disassociateWhenNotFoundValue: scala.Option[primitives.BoxBoolean] = scala.Option(impl.disassociateWhenNotFound()).map(value => value: primitives.BoxBoolean)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.UpdateLicenseConfigurationRequest): ReadOnly = new Wrapper(impl)
}