package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TokenData(tokenId: scala.Option[String] = None, tokenType: scala.Option[String] = None, licenseArn: scala.Option[String] = None, expirationTime: scala.Option[primitives.ISO8601DateTime] = None, tokenProperties: scala.Option[Iterable[String]] = None, roleArns: scala.Option[Iterable[primitives.Arn]] = None, status: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.TokenData = {
    import TokenData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.TokenData.builder().optionallyWith(tokenId.map(value => value: java.lang.String))(_.tokenId).optionallyWith(tokenType.map(value => value: java.lang.String))(_.tokenType).optionallyWith(licenseArn.map(value => value: java.lang.String))(_.licenseArn).optionallyWith(expirationTime.map(value => value: java.lang.String))(_.expirationTime).optionallyWith(tokenProperties.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.tokenProperties).optionallyWith(roleArns.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.roleArns).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
  }
  def asReadOnly: TokenData.ReadOnly = TokenData.wrap(buildAwsValue())
}
object TokenData {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.TokenData] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TokenData = TokenData(tokenIdValue.map(value => value), tokenTypeValue.map(value => value), licenseArnValue.map(value => value), expirationTimeValue.map(value => value), tokenPropertiesValue.map(value => value), roleArnsValue.map(value => value), statusValue.map(value => value))
    def tokenIdValue: scala.Option[String]
    def tokenTypeValue: scala.Option[String]
    def licenseArnValue: scala.Option[String]
    def expirationTimeValue: scala.Option[primitives.ISO8601DateTime]
    def tokenPropertiesValue: scala.Option[List[String]]
    def roleArnsValue: scala.Option[List[primitives.Arn]]
    def statusValue: scala.Option[String]
    def tokenId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenId", tokenIdValue)
    def tokenType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenType", tokenTypeValue)
    def licenseArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseArn", licenseArnValue)
    def expirationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expirationTime", expirationTimeValue)
    def tokenProperties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
    def roleArns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Arn]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArns", roleArnsValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.TokenData) extends TokenData.ReadOnly {
    override def tokenIdValue: scala.Option[String] = scala.Option(impl.tokenId()).map(value => value: String)
    override def tokenTypeValue: scala.Option[String] = scala.Option(impl.tokenType()).map(value => value: String)
    override def licenseArnValue: scala.Option[String] = scala.Option(impl.licenseArn()).map(value => value: String)
    override def expirationTimeValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.expirationTime()).map(value => value: primitives.ISO8601DateTime)
    override def tokenPropertiesValue: scala.Option[List[String]] = scala.Option(impl.tokenProperties()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def roleArnsValue: scala.Option[List[primitives.Arn]] = scala.Option(impl.roleArns()).map(value => value.asScala.map { item => 
      item: primitives.Arn
    }.toList)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.TokenData): ReadOnly = new Wrapper(impl)
}