package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class S3Location(bucket: scala.Option[String] = None, keyPrefix: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.S3Location.builder().optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket).optionallyWith(keyPrefix.map(value => value: java.lang.String))(_.keyPrefix).build()
  }
  def asReadOnly: S3Location.ReadOnly = S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.S3Location] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: S3Location = S3Location(bucketValue.map(value => value), keyPrefixValue.map(value => value))
    def bucketValue: scala.Option[String]
    def keyPrefixValue: scala.Option[String]
    def bucket: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bucket", bucketValue)
    def keyPrefix: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPrefix", keyPrefixValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.S3Location) extends S3Location.ReadOnly {
    override def bucketValue: scala.Option[String] = scala.Option(impl.bucket()).map(value => value: String)
    override def keyPrefixValue: scala.Option[String] = scala.Option(impl.keyPrefix()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.S3Location): ReadOnly = new Wrapper(impl)
}