package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ReportType { def unwrap: software.amazon.awssdk.services.licensemanager.model.ReportType }
object ReportType {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.ReportType): ReportType = value match {
    case software.amazon.awssdk.services.licensemanager.model.ReportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.ReportType.LICENSE_CONFIGURATION_SUMMARY_REPORT =>
      val r = LicenseConfigurationSummaryReport
      r
    case software.amazon.awssdk.services.licensemanager.model.ReportType.LICENSE_CONFIGURATION_USAGE_REPORT =>
      val r = LicenseConfigurationUsageReport
      r
  }
  case object unknownToSdkVersion extends ReportType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReportType = software.amazon.awssdk.services.licensemanager.model.ReportType.UNKNOWN_TO_SDK_VERSION }
  case object LicenseConfigurationSummaryReport extends ReportType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReportType = software.amazon.awssdk.services.licensemanager.model.ReportType.LICENSE_CONFIGURATION_SUMMARY_REPORT }
  case object LicenseConfigurationUsageReport extends ReportType { override def unwrap: software.amazon.awssdk.services.licensemanager.model.ReportType = software.amazon.awssdk.services.licensemanager.model.ReportType.LICENSE_CONFIGURATION_USAGE_REPORT }
}