package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReportContext(licenseConfigurationArns: Iterable[primitives.Arn]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ReportContext = {
    import ReportContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReportContext.builder().licenseConfigurationArns(licenseConfigurationArns.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: ReportContext.ReadOnly = ReportContext.wrap(buildAwsValue())
}
object ReportContext {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ReportContext] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReportContext = ReportContext(licenseConfigurationArnsValue)
    def licenseConfigurationArnsValue: List[primitives.Arn]
    def licenseConfigurationArns: ZIO[Any, Nothing, List[primitives.Arn]] = ZIO.succeed(licenseConfigurationArnsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ReportContext) extends ReportContext.ReadOnly {
    override def licenseConfigurationArnsValue: List[primitives.Arn] = impl.licenseConfigurationArns().asScala.map { item => 
      item: primitives.Arn
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ReportContext): ReadOnly = new Wrapper(impl)
}