package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReceivedMetadata(receivedStatus: scala.Option[ReceivedStatus] = None, allowedOperations: scala.Option[Iterable[AllowedOperation]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata = {
    import ReceivedMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata.builder().optionallyWith(receivedStatus.map(value => value.unwrap))(_.receivedStatus).optionallyWith(allowedOperations.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.allowedOperationsWithStrings).build()
  }
  def asReadOnly: ReceivedMetadata.ReadOnly = ReceivedMetadata.wrap(buildAwsValue())
}
object ReceivedMetadata {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReceivedMetadata = ReceivedMetadata(receivedStatusValue.map(value => value), allowedOperationsValue.map(value => value))
    def receivedStatusValue: scala.Option[ReceivedStatus]
    def allowedOperationsValue: scala.Option[List[AllowedOperation]]
    def receivedStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReceivedStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("receivedStatus", receivedStatusValue)
    def allowedOperations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AllowedOperation]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedOperations", allowedOperationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata) extends ReceivedMetadata.ReadOnly {
    override def receivedStatusValue: scala.Option[ReceivedStatus] = scala.Option(impl.receivedStatus()).map(value => ReceivedStatus.wrap(value))
    override def allowedOperationsValue: scala.Option[List[AllowedOperation]] = scala.Option(impl.allowedOperations()).map(value => value.asScala.map { item => 
      AllowedOperation.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ReceivedMetadata): ReadOnly = new Wrapper(impl)
}