package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ProvisionalConfiguration(maxTimeToLiveInMinutes: primitives.BoxInteger) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration = {
    import ProvisionalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration.builder().maxTimeToLiveInMinutes(maxTimeToLiveInMinutes: java.lang.Integer).build()
  }
  def asReadOnly: ProvisionalConfiguration.ReadOnly = ProvisionalConfiguration.wrap(buildAwsValue())
}
object ProvisionalConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ProvisionalConfiguration = ProvisionalConfiguration(maxTimeToLiveInMinutesValue)
    def maxTimeToLiveInMinutesValue: primitives.BoxInteger
    def maxTimeToLiveInMinutes: ZIO[Any, Nothing, primitives.BoxInteger] = ZIO.succeed(maxTimeToLiveInMinutesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration) extends ProvisionalConfiguration.ReadOnly { override def maxTimeToLiveInMinutesValue: primitives.BoxInteger = impl.maxTimeToLiveInMinutes(): primitives.BoxInteger }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ProvisionalConfiguration): ReadOnly = new Wrapper(impl)
}