package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Metadata(name: scala.Option[String] = None, value: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.Metadata = {
    import Metadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Metadata.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: Metadata.ReadOnly = Metadata.wrap(buildAwsValue())
}
object Metadata {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.Metadata] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Metadata = Metadata(nameValue.map(value => value), valueValue.map(value => value))
    def nameValue: scala.Option[String]
    def valueValue: scala.Option[String]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.Metadata) extends Metadata.ReadOnly {
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.Metadata): ReadOnly = new Wrapper(impl)
}