package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseManagerReportGeneratorsRequest(filters: scala.Option[Iterable[Filter]] = None, nextToken: scala.Option[String] = None, maxResults: scala.Option[primitives.MaxSize100] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest = {
    import ListLicenseManagerReportGeneratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest.builder().optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListLicenseManagerReportGeneratorsRequest.ReadOnly = ListLicenseManagerReportGeneratorsRequest.wrap(buildAwsValue())
}
object ListLicenseManagerReportGeneratorsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseManagerReportGeneratorsRequest = ListLicenseManagerReportGeneratorsRequest(filtersValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def maxResultsValue: scala.Option[primitives.MaxSize100]
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxSize100] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest) extends ListLicenseManagerReportGeneratorsRequest.ReadOnly {
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
    override def maxResultsValue: scala.Option[primitives.MaxSize100] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxSize100)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest): ReadOnly = new Wrapper(impl)
}