package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListLicenseConfigurationsResponse(licenseConfigurations: scala.Option[Iterable[LicenseConfiguration]] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse = {
    import ListLicenseConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse.builder().optionallyWith(licenseConfigurations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseConfigurations).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListLicenseConfigurationsResponse.ReadOnly = ListLicenseConfigurationsResponse.wrap(buildAwsValue())
}
object ListLicenseConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListLicenseConfigurationsResponse = ListLicenseConfigurationsResponse(licenseConfigurationsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def licenseConfigurationsValue: scala.Option[List[LicenseConfiguration.ReadOnly]]
    def nextTokenValue: scala.Option[String]
    def licenseConfigurations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LicenseConfiguration.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConfigurations", licenseConfigurationsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse) extends ListLicenseConfigurationsResponse.ReadOnly {
    override def licenseConfigurationsValue: scala.Option[List[LicenseConfiguration.ReadOnly]] = scala.Option(impl.licenseConfigurations()).map(value => value.asScala.map { item => 
      LicenseConfiguration.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListLicenseConfigurationsResponse): ReadOnly = new Wrapper(impl)
}