package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListFailuresForLicenseConfigurationOperationsRequest(licenseConfigurationArn: String, maxResults: scala.Option[primitives.BoxInteger] = None, nextToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest = {
    import ListFailuresForLicenseConfigurationOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest.builder().licenseConfigurationArn(licenseConfigurationArn: java.lang.String).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListFailuresForLicenseConfigurationOperationsRequest.ReadOnly = ListFailuresForLicenseConfigurationOperationsRequest.wrap(buildAwsValue())
}
object ListFailuresForLicenseConfigurationOperationsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListFailuresForLicenseConfigurationOperationsRequest = ListFailuresForLicenseConfigurationOperationsRequest(licenseConfigurationArnValue, maxResultsValue.map(value => value), nextTokenValue.map(value => value))
    def licenseConfigurationArnValue: String
    def maxResultsValue: scala.Option[primitives.BoxInteger]
    def nextTokenValue: scala.Option[String]
    def licenseConfigurationArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseConfigurationArnValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxInteger] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest) extends ListFailuresForLicenseConfigurationOperationsRequest.ReadOnly {
    override def licenseConfigurationArnValue: String = impl.licenseConfigurationArn(): String
    override def maxResultsValue: scala.Option[primitives.BoxInteger] = scala.Option(impl.maxResults()).map(value => value: primitives.BoxInteger)
    override def nextTokenValue: scala.Option[String] = scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest): ReadOnly = new Wrapper(impl)
}