package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LicenseConfigurationUsage(resourceArn: scala.Option[String] = None, resourceType: scala.Option[ResourceType] = None, resourceStatus: scala.Option[String] = None, resourceOwnerId: scala.Option[String] = None, associationTime: scala.Option[primitives.DateTime] = None, consumedLicenses: scala.Option[primitives.BoxLong] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage = {
    import LicenseConfigurationUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage.builder().optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(resourceStatus.map(value => value: java.lang.String))(_.resourceStatus).optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(_.resourceOwnerId).optionallyWith(associationTime.map(value => value: java.time.Instant))(_.associationTime).optionallyWith(consumedLicenses.map(value => value: java.lang.Long))(_.consumedLicenses).build()
  }
  def asReadOnly: LicenseConfigurationUsage.ReadOnly = LicenseConfigurationUsage.wrap(buildAwsValue())
}
object LicenseConfigurationUsage {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LicenseConfigurationUsage = LicenseConfigurationUsage(resourceArnValue.map(value => value), resourceTypeValue.map(value => value), resourceStatusValue.map(value => value), resourceOwnerIdValue.map(value => value), associationTimeValue.map(value => value), consumedLicensesValue.map(value => value))
    def resourceArnValue: scala.Option[String]
    def resourceTypeValue: scala.Option[ResourceType]
    def resourceStatusValue: scala.Option[String]
    def resourceOwnerIdValue: scala.Option[String]
    def associationTimeValue: scala.Option[primitives.DateTime]
    def consumedLicensesValue: scala.Option[primitives.BoxLong]
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def resourceStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceStatus", resourceStatusValue)
    def resourceOwnerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerIdValue)
    def associationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associationTime", associationTimeValue)
    def consumedLicenses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BoxLong] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("consumedLicenses", consumedLicensesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage) extends LicenseConfigurationUsage.ReadOnly {
    override def resourceArnValue: scala.Option[String] = scala.Option(impl.resourceArn()).map(value => value: String)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def resourceStatusValue: scala.Option[String] = scala.Option(impl.resourceStatus()).map(value => value: String)
    override def resourceOwnerIdValue: scala.Option[String] = scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override def associationTimeValue: scala.Option[primitives.DateTime] = scala.Option(impl.associationTime()).map(value => value: primitives.DateTime)
    override def consumedLicensesValue: scala.Option[primitives.BoxLong] = scala.Option(impl.consumedLicenses()).map(value => value: primitives.BoxLong)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.LicenseConfigurationUsage): ReadOnly = new Wrapper(impl)
}