package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class IssuerDetails(name: scala.Option[String] = None, signKey: scala.Option[String] = None, keyFingerprint: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.IssuerDetails = {
    import IssuerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.IssuerDetails.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(signKey.map(value => value: java.lang.String))(_.signKey).optionallyWith(keyFingerprint.map(value => value: java.lang.String))(_.keyFingerprint).build()
  }
  def asReadOnly: IssuerDetails.ReadOnly = IssuerDetails.wrap(buildAwsValue())
}
object IssuerDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.IssuerDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: IssuerDetails = IssuerDetails(nameValue.map(value => value), signKeyValue.map(value => value), keyFingerprintValue.map(value => value))
    def nameValue: scala.Option[String]
    def signKeyValue: scala.Option[String]
    def keyFingerprintValue: scala.Option[String]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def signKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("signKey", signKeyValue)
    def keyFingerprint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyFingerprint", keyFingerprintValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.IssuerDetails) extends IssuerDetails.ReadOnly {
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def signKeyValue: scala.Option[String] = scala.Option(impl.signKey()).map(value => value: String)
    override def keyFingerprintValue: scala.Option[String] = scala.Option(impl.keyFingerprint()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.IssuerDetails): ReadOnly = new Wrapper(impl)
}