package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait GrantStatus { def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus }
object GrantStatus {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.GrantStatus): GrantStatus = value match {
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_WORKFLOW =>
      val r = PENDING_WORKFLOW
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_ACCEPT =>
      val r = PENDING_ACCEPT
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.REJECTED =>
      val r = REJECTED
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.FAILED_WORKFLOW =>
      val r = FAILED_WORKFLOW
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_DELETE =>
      val r = PENDING_DELETE
      r
    case software.amazon.awssdk.services.licensemanager.model.GrantStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_WORKFLOW extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_WORKFLOW }
  case object PENDING_ACCEPT extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_ACCEPT }
  case object REJECTED extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.REJECTED }
  case object ACTIVE extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.ACTIVE }
  case object FAILED_WORKFLOW extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.FAILED_WORKFLOW }
  case object DELETED extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.DELETED }
  case object PENDING_DELETE extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.PENDING_DELETE }
  case object DISABLED extends GrantStatus { override def unwrap: software.amazon.awssdk.services.licensemanager.model.GrantStatus = software.amazon.awssdk.services.licensemanager.model.GrantStatus.DISABLED }
}